<?php

class Api {
    private $config;

    function __construct($options) {
        $this->config = $options['config'];
    }

    function initialize() {
        register_rest_route('wc/misys-v3', '/ping', [
            'methods' => 'POST',
            'callback' => [$this, 'ping'],
            'permission_callback' => [$this, 'checkWooCommercePermissions']
        ]);

        register_rest_route('wc/misys-v3', '/subscriber', [
            'methods' => 'GET',
            'callback' => [$this, 'listSubscribers'],
            'permission_callback' => [$this, 'checkWooCommercePermissions']
        ]);

        register_rest_route('wc/misys-v3', '/subscribe', [
            'methods' => 'POST',
            'callback' => [$this, 'subscribe'],
            'permission_callback' => [$this, 'checkWooCommercePermissions']
        ]);

        register_rest_route('wc/misys-v3', '/unsubscribe', [
            'methods' => 'POST',
            'callback' => [$this, 'unsubscribe'],
            'permission_callback' => [$this, 'checkWooCommercePermissions']
        ]);
    }

    function addSubscribeCheckbox() {
        woocommerce_form_field('miv3_order_subscribe', [
            'type' => 'checkbox',
            'class' => ['form-row miv3-subscribe-checkbox'],
            'required' => false,
            'label' => __('Szeretném megkapni a legjobb ajánlataitokat, ezért vegyetek fel a hírlevél listátokra!', 'miv3')
        ]);
    }

    function processCheckout() {
        if (!isset($_POST)) {
            return;
        }

        if (!isset($_POST['billing_email'])) {
            return;
        }

        if (!isset($_POST['miv3_order_subscribe'])) {
            return;
        }

        $email = $_POST['billing_email'];
        $subscribe = $_POST['miv3_order_subscribe'];

        if (!$email) {
            return;
        }

        if ($subscribe === '0') {
            return;
        }

        if ($subscribe === 0) {
            return;
        }

        if (!$subscribe) {
            return;
        }

        $this->config->subscribe(
            $email,
            isset($_POST['billing_first_name']) ? $_POST['billing_first_name'] : '',
            isset($_POST['billing_last_name']) ? $_POST['billing_last_name'] : ''
        );
    }

    function listSubscribers(WP_REST_Request $request) {
        $page = $request->get_param('page');
        $limit = $request->get_param('per_page');

        return $this->config->listSubscribers(
            (int)(isset($page) ? $page : 1),
            (int)(isset($limit) ? $limit : 100)
        );
    }

    function subscribe(WP_REST_Request $request) {
        $body = json_decode($request->get_body());

        if (!$body->email) {
            return new WP_Error('MissingEmail');
        }

        $this->config->subscribe($body->email, $body->firstName, $body->lastName);

        return [
            'email' => $body->email,
            'firstName' => $body->firstName,
            'lastName' => $body->lastName,
            'subscribed' => $this->config->isSubscribed($body->email)
        ];
    }

    function unsubscribe(WP_REST_Request $request) {
        $body = json_decode($request->get_body());

        if (!$body->email) {
            return new WP_Error('MissingEmail');
        }

        $this->config->unsubscribe($body->email, $body->firstName, $body->lastName);

        return [
            'email' => $body->email,
            'firstName' => $body->firstName,
            'lastName' => $body->lastName,
            'subscribed' => $this->config->isSubscribed($body->email)
        ];
    }

    function checkWooCommercePermissions( $request ) {
		if ( ! wc_rest_check_user_permissions( 'read' ) ) {
			return new WP_Error( 'woocommerce_rest_cannot_view', __( 'Sorry, you cannot list resources.', 'woocommerce' ), array( 'status' => rest_authorization_required_code() ) );
		}

		return true;
    }
}
