<?php

class Session {
    private $config;

    function __construct($options) {
        $this->config = $options['config'];
    }

    function initSid() {
        try {
            $sid = $this->getSid();

            if (!isset($sid)) {
                setcookie('miv3-sid', $this->genSid(40), -1);
            }

            if (isset($_GET['_emailId'])) {
                setcookie('miv3-femailId', $_GET['_emailId'], -1);
            }

            if (isset($_GET['_cId'])) {
                setcookie('miv3-fcid', $_GET['_cId'], -1);
            }
        } catch(Exception $e) {
            //
        }
    }

    function regenerateSid() {
        setcookie('miv3-sid', $this->genSid(40), -1);
        setcookie('miv3-femailId', '', -1);
        setcookie('miv3-fcid', '', -1);
    }

    function getSid() {
        return $_COOKIE['miv3-sid'];
    }

    function getForceEmailId() {
        if (!isset($_COOKIE['miv3-femailId'])) {
            return null;
        }

        return $_COOKIE['miv3-femailId'];
    }

    function genSid($length = 10) {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }

    function getCid() {
        try {
            $forceCid = "";

            if (isset($_COOKIE['miv3-fcid'])) {
                $forceCid = $_COOKIE['miv3-fcid'];
            }

            if(isset($forceCid)) {
                if($forceCid !== "") {
                    return $forceCid;
                }
            }

            $user = wp_get_current_user();

            if (!isset($user)) {
                return null;
            }

            if (!isset($user->user_email)) {
                return null;
            }

            if (!$user->user_email) {
                return null;
            }

            $userEmail = $user->user_email;

            if (!$userEmail) {
                return null;
            }

            return bin2hex($userEmail);
        } catch(Exception $e) {
            return null;
        }
    }
}
