<?php

require_once('config.php');
require_once('event.php');
require_once('session.php');
require_once('gui/gui.php');
require_once('subscription/api.php');

class Initialize {
    public $config;
    public $event;
    public $session;
    public $gui;
    public $api;

    function onLoad() {
        $this->config = new Config();

        $this->api = new Api([
            'config' => $this->config
        ]);

        $this->session = new Session([
            'config' => $this->config
        ]);

        $this->event = new Event([
            'config' => $this->config,
            'session' => $this->session
        ]);
    
        $this->gui = new Gui([
            'config' => $this->config,
            'session' => $this->session
        ]);

        $this->config->createTables();
        $this->session->initSid();

        add_action('plugins_loaded', [$this->gui, 'init']);
        add_action('wp_head', [$this->event, 'pageView'], 10);
        add_action('wp_head', [$this->event, 'cartChange'], 10);
        add_action('wp_login', [$this->event, 'login'], 10, 2);
        add_action('wp_logout', [$this->event, 'logout'], 10);

        add_action('rest_api_init', [$this->api, 'initialize'], 10);
        add_action('woocommerce_review_order_before_submit', [$this->api, 'addSubscribeCheckbox'], 10);
        add_action('woocommerce_checkout_process', [$this->api, 'processCheckout'], 10);

        add_action('woocommerce_before_single_product', [$this->event, 'productView'], 10);
        add_action('woocommerce_before_shop_loop', [$this->event, 'categoryView'], 10, 2);
        add_action('woocommerce_add_to_cart', [$this->event, 'addToCart'], 10, 6);
        add_action('woocommerce_checkout_order_processed', [$this->event, 'order'], 10, 2);
        add_action('activated_plugin', [$this, 'redirectAfterActivate']);
    }

    function redirectAfterActivate() {
        exit( wp_safe_redirect('/wp-admin/admin.php?page=misys-v3-settings') );
    }
}
