<?php

class Settings {
    private $session;
    private $config;

    function __construct($options) {
        $this->session = $options['session'];
        $this->config = $options['config'];
    }

    function render() {
        $this->handleFormSubmit();

        ?>
            <div class="wrap">
                <?php $this->renderHeader(); ?>
                <?php $this->renderWelcome(); ?>
                <?php $this->renderAlerts(); ?>
                <?php $this->renderForm(); ?>
            </div>
        <?php

        $this->handleVisit();
    }

    function handleFormSubmit() {
        if (isset($_POST['iId'])) {
            $this->config->set('integration', $_POST['iId']);
        }
    }

    function handleVisit() {
        $this->config->set('welcome-visited', true);
    }

    function renderHeader() {
        ?>
            <h1>MI mesterséges inteligencia - Beállítások</h1>
        <?php
    }

    function renderAlerts() {
        $iId = $this->config->get('integration');

        if (!!$iId) {
            ?>
            <div class="notice notice-success">
                <h3>Minden megfelelően működik!</h3>
            </div>
            <?php

            return;
        }

        $isAlreadyVisited = $this->config->exists('welcome-visited');

        if (!$isAlreadyVisited) {
            return;
        }

        ?>
        <div class="notice notice-error">
            <h3>Jelenleg sajnos nincs megfelelően konfigurálva az integrációd!</h3>
            <p>A megfelelő konfigurációhoz kérjük töltsd ki az alább látható <b>"Integrációs azonosító"</b> mezőt</p>
        </div>
        <?php
    }

    function renderWelcome() {
        $iId = $this->config->get('integration');

        if ($iId) {
            return;
        }

        $isAlreadyVisited = $this->config->exists('welcome-visited');

        if ($isAlreadyVisited) {
            return;
        }

        ?>
        <div class="notice notice-success">
            <h3>Üdvözlünk!</h3>

            <p>Az <b>MISysV3 WordPress Plugin - Beállítások</b> oldalán vagy!</p>
            <p>Az integráció megfelelő működéséhez egy rövid konfiguráció szükséges.</p>
            <p>Nincs más dolgod, mint az alábbi <b>"Integrációs azonosító"</b> mező kitöltésével, összekösd az MISysV3 fiókodat és a webáruházadat</p>
        </div>
        <?php
    }

    function renderForm() {
        $iId = $this->config->get('integration');

        ?>
        <form method="post" action="/wp-admin/admin.php?page=misys-v3-settings">
            <input
                style="padding: .5rem 1rem; width: 100%; max-width: 300px;"
                type="text"
                name="iId"
                placeholder="Integrációs azonosító" 
                value="<?php echo($iId); ?>"
            />

            <?php submit_button('Mentés') ?>

        </form>
        <?php
    }
}