<?php

require_once('views/settings.php');

class Gui {
    private $session;
    private $config;
    private $views;

    function __construct($options) {
        $this->session = $options['session'];
        $this->config = $options['config'];

        $this->views = [
            'settings' => new Settings([
                'session' => $this->session,
                'config' => $this->config
            ])
        ];
    }

    function init() {
        $this->addSettingsButton();
    }

    function addSettingsButton() {
        add_menu_page( 
            'MISys V3',
            'MISys V3',
            'manage_options',
            'misys-v3-settings',
            [$this->views['settings'], 'render']
        );
    }
}