<?php

class Event 
{
    private $url = "https://event.v3.miclub.hu";
    private $session;
    private $config;

    function __construct($options) {
        $this->session = $options['session'];
        $this->config = $options['config'];
    }

    function pageView() {
        try {
            $this->sendEvent('page-view', []);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function categoryView() {
        try {
            global $wp_query;
        
            $qo = $wp_query->get_queried_object();
            
            if (isset($qo->term_id)) {
                $this->sendEvent('category-view', [
                    'identifier' => $qo->term_id
                ]);
            }
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function productView() {
        try {
            global $wp_query;
        
            $qo = $wp_query->get_queried_object();
            
            if (isset($qo->ID)) {
                $this->sendEvent('product-view', [
                    'identifier' => $qo->ID
                ]);
            }
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function login($user_login, $user) {
        try {
            $this->sendEvent('login', [
                'identifier' => $user->ID
            ]);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function logout() {
        $this->session->regenerateSid();

        try {
            $this->sendEvent('logout', []);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function order($order_id) {
        try {
            $this->sendEvent('order', [
                'identifier' => $order_id
            ]);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function addToCart($cart_item_key,  $product_id,  $quantity,  $variation_id,  $variation,  $cart_item_data) {
        try {
            $this->sendEvent('add-to-cart', [
                'identifier' => $product_id,
                'amount' => $quantity
            ]);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    function cartChange() {
        try {
            global $woocommerce;

            if (!isset($woocommerce)) {
                return;
            }

            if (!isset($woocommerce->cart)) {
                return;
            }

            $cart = $woocommerce->cart->get_cart();

            $items = [];
            $total = 0;

            foreach ($cart as $key => $value) {
                $items[] = $value['product_id'];
            }

            foreach ($cart as $key => $value) {
                $total += $value['line_total'];
            }

            $this->sendEvent('cart-change', [
                'identifiers' => $items,
                'value' => $total
            ]);
        } catch(Exception $e) {
            // Silence is golden
        }
    }

    private function sendEvent($type, $payload) {
        try {
            $iId = $this->config->get('integration');
        
            if (!isset($iId)) {
                return;
            }
            
            if (!$iId) {
                return;
            }

            $response = wp_remote_post('https://event.v3.miclub.hu/incoming', [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Origin' => get_site_url()
                ],
                'body' => json_encode([
                    'version' => '1.2',
                    'iId' => $iId,
                    'sId' => $this->session->getSid(),
                    'cId' => $this->session->getCid(),
                    'emailId' => $this->session->getForceEmailId(),
                    'type' => $type,
                    'payload' => $payload,
                    'meta' => [
                        'time' => date('Y-m-d H:i:s'),
                        'timezoneOffset' => date('Z') / -60,
                        'userAgent' => $_SERVER['HTTP_USER_AGENT'],
                        'href' => home_url($_SERVER['REQUEST_URI'])
                    ],
                    'shopType' => 'WooCommerce',
                ])
            ]);
        } catch (Exception $e) {
            // Silenceis golden
        }
    }
}
