<?php

require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

class Config {
    function createTables() {
        global $wpdb;

        $tableNames = $this->getTableNames();
        
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        
        dbDelta( "CREATE TABLE IF NOT EXISTS {$tableNames['settings']} (
            id INT AUTO_INCREMENT PRIMARY KEY,
            `key` VARCHAR(255) NOT NULL,
            `value` TEXT
        );" );

        dbDelta( "CREATE TABLE IF NOT EXISTS {$tableNames['subscribers']} (
            id INT AUTO_INCREMENT PRIMARY KEY,
            `email` VARCHAR(255) NOT NULL,
            `firstName` VARCHAR(255),
            `lastName` VARCHAR(255),
            `subscribed` TINYINT,
            `subscribedAt` DATETIME,
            `unsubscribedAt` DATETIME
        );" );
    }

    function deleteTables() {
        global $wpdb;

        $tableNames = $this->getTableNames();
        
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        
        dbDelta( "DROP TABLE IF EXISTS `{$tableNames['settings']}`" );
        dbDelta( "DROP TABLE IF EXISTS `{$tableNames['subscribers']}`" );
    }

    function get($key) {
        global $wpdb;

        $tableNames = $this->getTableNames();

        return $wpdb->get_results("SELECT * FROM {$tableNames['settings']} WHERE `key` = '{$key}' ")[0]->value;
    }

    function exists($key) {
        global $wpdb;

        $tableNames = $this->getTableNames();

        return $wpdb->get_var("SELECT count(*) FROM {$tableNames['settings']} WHERE `key` = '{$key}' ") > 0;
    }

    function set($key, $value) {
        global $wpdb;

        $tableNames = $this->getTableNames();
        $exists = $this->exists($key);

        if ($exists) {
            $wpdb->update( 
                $tableNames['settings'], 
                ['value' => $value],
                ['key' => $key]
            );
        } else {
            $wpdb->insert( 
                $tableNames['settings'], 
                ['key' => $key, 'value' => $value]
            );
        }
    }

    function isSubscribed($email) {
        global $wpdb;

        $tableNames = $this->getTableNames();

        return $wpdb->get_var("SELECT count(*) FROM {$tableNames['subscribers']} WHERE `email` = '{$email}' and `subscribed` = 1 ") > 0;
    }

    function isSubscriberExists($email) {
        global $wpdb;

        $tableNames = $this->getTableNames();

        return $wpdb->get_var("SELECT count(*) FROM {$tableNames['subscribers']} WHERE `email` = '{$email}'") > 0;
    }

    function listSubscribers($page = 1, $limit = 100) {
        global $wpdb;

        $tableNames = $this->getTableNames();

        $skip = ($page - 1) * $limit;

        return $wpdb->get_results("SELECT * FROM {$tableNames['subscribers']} LIMIT {$skip}, {$limit}");
    }

    function subscribe($email, $firstName = '', $lastName = '') {
        global $wpdb;

        $tableNames = $this->getTableNames();
        $exists = $this->isSubscriberExists($email);

        if (!$exists) {
            $wpdb->insert(
                $tableNames['subscribers'],
                [
                    'subscribedAt' => date(DATE_ATOM),
                    'email' => $email,
                    'subscribed' => 1,
                    'firstName' => $firstName,
                    'lastName' => $lastName
                ]
            );
        } else {
            $wpdb->update(
                $tableNames['subscribers'],
                [
                    'subscribedAt' => date(DATE_ATOM),
                    'subscribed' => 1,
                    'firstName' => $firstName,
                    'lastName' => $lastName
                ],
                ['email' => $email]
            );
        }
    }

    function unsubscribe($email, $firstName = '', $lastName = '') {
        global $wpdb;

        $tableNames = $this->getTableNames();
        $exists = $this->isSubscriberExists($email);

        if (!$exists) {
            $wpdb->insert(
                $tableNames['subscribers'],
                [
                    'unsubscribedAt' => date(DATE_ATOM),
                    'email' => $email,
                    'subscribed' => 0,
                    'firstName' => $firstName,
                    'lastName' => $lastName
                ]
            );
        } else {
            $wpdb->update(
                $tableNames['subscribers'],
                [
                    'unsubscribedAt' => date(DATE_ATOM),
                    'subscribed' => 0,
                    // 'firstName' => $firstName,
                    // 'lastName' => $lastName
                ],
                ['email' => $email]
            );
        }
    }

    function getTableNames() {
        global $wpdb;

        return [
            'settings' => $wpdb->prefix . 'misys_settings',
            'subscribers' => $wpdb->prefix . 'misys_subscribers'
        ];
    }
}
